/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.MineColonies;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class CreateColonyMessage
implements IMessage {
    BlockPos townHall;
    String colonyName;

    public CreateColonyMessage() {
    }

    public CreateColonyMessage(BlockPos townHall, String colonyName) {
        this.townHall = townHall;
        this.colonyName = colonyName;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.townHall);
        buf.func_180714_a(this.colonyName);
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        this.townHall = buf.func_179259_c();
        this.colonyName = buf.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayerEntity sender = ctxIn.getSender();
        World world = ctxIn.getSender().field_70170_p;
        if (sender == null) {
            return;
        }
        if (sender.func_147099_x().func_77444_a(Stats.field_75929_E.func_199076_b((Object)ModItems.supplyChest)) <= 0 && !sender.func_184812_l_()) {
            MessageUtils.format("com.minecolonies.coremod.supplyneed", new Object[0]).sendTo(new PlayerEntity[]{sender});
            return;
        }
        IColony colony = IColonyManager.getInstance().getClosestColony(world, this.townHall);
        String style = "wooden";
        TileEntity tileEntity = world.func_175625_s(this.townHall);
        if (!(tileEntity instanceof TileEntityColonyBuilding)) {
            MessageUtils.format("com.minecolonies.coremod.gui.colony.create.notileentity", new Object[0]).with(TextFormatting.BOLD, TextFormatting.DARK_RED).sendTo(new PlayerEntity[]{sender});
            return;
        }
        if (!((AbstractTileEntityColonyBuilding)tileEntity).getStyle().isEmpty()) {
            style = ((AbstractTileEntityColonyBuilding)tileEntity).getStyle();
        }
        if (((Boolean)MineColonies.getConfig().getServer().restrictColonyPlacement.get()).booleanValue()) {
            double spawnDistance = Math.sqrt(BlockPosUtil.getDistanceSquared2D(this.townHall, ((ServerWorld)world).func_241135_u_()));
            if (spawnDistance < (double)((Integer)MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()).intValue()) {
                if (!world.field_72995_K) {
                    MessageUtils.format("com.minecolonies.coremod.tooclose", MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()).sendTo(new PlayerEntity[]{sender});
                }
                return;
            }
            if (spawnDistance > (double)((Integer)MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get()).intValue()) {
                if (!world.field_72995_K) {
                    MessageUtils.format("com.minecolonies.coremod.toofar", MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get()).sendTo(new PlayerEntity[]{sender});
                }
                return;
            }
        }
        if (colony != null && !IColonyManager.getInstance().isFarEnoughFromColonies(world, this.townHall)) {
            MessageUtils.format("com.minecolonies.coremod.gui.colony.denied.tooclose", colony.getName()).sendTo(new PlayerEntity[]{sender});
            return;
        }
        IColony ownedColony = IColonyManager.getInstance().getIColonyByOwner(world, (PlayerEntity)sender);
        if (ownedColony == null) {
            IColonyManager.getInstance().createColony(world, this.townHall, (PlayerEntity)sender, this.colonyName, style);
            IColonyManager.getInstance().getIColonyByOwner(world, (PlayerEntity)sender).getBuildingManager().addNewBuilding((TileEntityColonyBuilding)tileEntity, world);
            MessageUtils.format("com.minecolonies.coremod.progress.colony_founded", new Object[0]).with(TextFormatting.GOLD).sendTo(new PlayerEntity[]{sender});
            return;
        }
        MessageUtils.format("com.minecolonies.coremod.gui.colony.create.failed", new Object[0]).with(TextFormatting.BOLD, TextFormatting.DARK_RED).sendTo(new PlayerEntity[]{sender});
    }
}

